# Moggi Wallet Tracker

A Chrome extension for real-time wallet tracking on the Monad blockchain. Get instant notifications when tracked wallets make transactions or trades.

## Features

- **Real-time Tracking**: WebSocket connection to Moggi API for instant transaction notifications
- **Multiple Wallets**: Track unlimited wallet addresses with custom nicknames
- **Trade Detection**: Automatic detection of trades on Nad.fun and bonding curves
- **In-Page Notifications**: Sleek notifications that appear on websites you're browsing
- **Chrome Notifications**: Browser notifications when the window is not focused
- **Click to Explore**: Click notifications to view transactions on moggi.tools or tokens on gmgn.ai
- **Customizable Display**: Choose where notifications appear (gmgn.ai only or all sites)

## Installation

1. Download or clone this repository
2. Open Chrome and navigate to `chrome://extensions`
3. Enable "Developer mode" (toggle in top right)
4. Click "Load unpacked"
5. Select the `Moggi_chrome` folder
6. The extension icon will appear in your toolbar

## Setup

### 1. Get Your API Key

Obtain an API key from [Moggi Tools](https://moggi.tools).

### 2. Configure the Extension

1. Click the Moggi extension icon in your toolbar
2. Enter your API key and click **Save**
3. Add wallets you want to track:
   - Enter the wallet address (0x...)
   - Give it a nickname (e.g., "Whale1", "Smart Money")
   - Click **Add**
4. Click **Connect to WebSocket**

## Settings

| Setting | Description |
|---------|-------------|
| **Show notifications on all websites** | When ON, in-page notifications show on any website. When OFF, only shows on gmgn.ai |
| **Browser notifications when unfocused** | When ON, shows Chrome notifications when browser window is not focused |
| **Show all transactions** | When ON, shows all transactions (transfers, contracts). When OFF, only shows detected trades |

## Notification Types

### Trade Notifications
Triggered when a tracked wallet buys or sells on Nad.fun or detected bonding curves.

- Shows: Wallet nickname, BUY/SELL action, token symbol, token amount, MON amount
- Click action (on gmgn.ai): Opens token page at `gmgn.ai/monad/token/{address}`

### Transaction Notifications
Triggered for other transactions (transfers, contract interactions).

| Type | Description |
|------|-------------|
| **Sent MON** | Wallet sent MON to another address |
| **Received MON** | Wallet received MON from another address |
| **New Transaction** | Contract interaction or other transaction |

- Click action: Opens transaction on `mainnet.moggi.tools/tx/{hash}`

## File Structure

```
Moggi_chrome/
  manifest.json       # Extension configuration
  background.js       # WebSocket connection & message handling
  content.js          # In-page notification injection
  notification.css    # Notification styling
  popup.html          # Extension popup UI
  popup.css           # Popup styling
  popup.js            # Popup logic
  README.md           # Documentation
  icons/              # Extension icons
    icon.svg
    icon16.jpeg
    icon32.jpeg
    icon48.jpeg
    icon128.jpeg
```

## API Reference

The extension connects to the Moggi WebSocket API:

```
wss://api.moggi.tools/ws?key={API_KEY}
```

### Subscribe to Wallet

```json
{
  "action": "subscribe",
  "type": "address",
  "address": "0x..."
}
```

### Unsubscribe from Wallet

```json
{
  "action": "unsubscribe",
  "type": "address",
  "address": "0x..."
}
```

### Incoming Messages

**Transaction Event:**
```json
{
  "type": "new_transaction",
  "transaction_type": "trade | transfer",
  "data": {
    "hash": "0x...",
    "from_address": "0x...",
    "to_address": "0x...",
    "value": "0x...",
    "input": "0x...",
    "block_number": 123456
  },
  "trade": {
    "token_address": "0x...",
    "token_symbol": "TOKEN",
    "token_name": "Token Name",
    "token_image": "https://...",
    "is_buy": true,
    "mon_amount_formatted": "1.5",
    "token_amount_formatted": "1000"
  }
}
```

Note: `trade` is `null` for non-trade transactions.

## Troubleshooting

### Notifications not showing
1. Check that the extension is connected (green status dot)
2. Verify wallets are added correctly
3. Check if "Show on all sites" is enabled for non-gmgn.ai sites
4. Reload the extension from `chrome://extensions`

### WebSocket disconnecting
- The extension automatically reconnects up to 5 times
- Check your API key is valid
- Check your internet connection

### Chrome notifications not appearing
1. Ensure "Browser notifications when unfocused" is enabled
2. Check Chrome notification permissions in system settings
3. Notifications only show when the browser window is not focused

## Design

The extension uses the Moggi design system:

| Element | Color |
|---------|-------|
| Background | `#0b0b0f` |
| Surface | `#111119` |
| Border | `#26263a` |
| Primary (Pink) | `#ff66c4` |
| Accent (Teal) | `#00e5ff` |
| Text | `#e7e7ee` |

- Blocky, sharp design (4px border radius)
- Flat shadows with lift effect on hover
- Monospace fonts for addresses and hashes

## License

MIT License

## Support

For issues or feature requests, contact the Moggi team or open an issue in the repository.
